% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/means_ratio.R
\name{means_ratio}
\alias{means_ratio}
\title{Ratio of Means}
\usage{
means_ratio(
  x,
  y = NULL,
  data = NULL,
  paired = FALSE,
  adjust = TRUE,
  log = FALSE,
  ci = 0.95,
  alternative = "two.sided",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x, y}{A numeric vector, or a character name of one in \code{data}.
Any missing values (\code{NA}s) are dropped from the resulting vector.
\code{x} can also be a formula (see \code{\link[stats:t.test]{stats::t.test()}}), in which case \code{y} is
ignored.}

\item{data}{An optional data frame containing the variables.}

\item{paired}{If \code{TRUE}, the values of \code{x} and \code{y} are considered as paired.
The correlation between these variables will affect the CIs.}

\item{adjust}{Should the effect size be adjusted for small-sample bias?
Defaults to \code{TRUE}; Advisable for small samples.}

\item{log}{Should the log-ratio be returned? Defaults to \code{FALSE}.
Normally distributed and useful for meta-analysis.}

\item{ci}{Confidence Interval (CI) level}

\item{alternative}{a character string specifying the alternative hypothesis;
Controls the type of CI returned: \code{"two.sided"} (default, two-sided CI),
\code{"greater"} or \code{"less"} (one-sided CI). Partial matching is allowed (e.g.,
\code{"g"}, \code{"l"}, \code{"two"}...). See \emph{One-Sided CIs} in \link{effectsize_CIs}.}

\item{verbose}{Toggle warnings and messages on or off.}

\item{...}{Arguments passed to or from other methods. When \code{x} is a formula,
these can be \code{subset} and \code{na.action}.}
}
\value{
A data frame with the effect size (\code{Means_ratio} or
\code{Means_ratio_adjusted}) and their CIs (\code{CI_low} and \code{CI_high}).
}
\description{
Computes the ratio of two means (also known as the "response ratio"; RR) of
\strong{variables on a ratio scale} (with an absolute 0). Pair with any reported
\code{\link[stats:t.test]{stats::t.test()}}.
}
\details{
The Means Ratio ranges from 0 to \eqn{\infty}, with values smaller than 1
indicating that the second mean is larger than the first, values larger than
1 indicating that the second mean is smaller than the first, and values of 1
indicating that the means are equal.
}
\note{
The small-sample bias corrected response ratio reported from this
function is derived from Lajeunesse (2015).
}
\section{Confidence (Compatibility) Intervals (CIs)}{
Confidence intervals are estimated as described by Lajeunesse (2011 & 2015)
using the log-ratio standard error assuming a normal distribution. By this
method, the log is taken of the ratio of means, which makes this outcome
measure symmetric around 0 and yields a corresponding sampling distribution
that is closer to normality.
}

\section{CIs and Significance Tests}{
"Confidence intervals on measures of effect size convey all the information
in a hypothesis test, and more." (Steiger, 2004). Confidence (compatibility)
intervals and p values are complementary summaries of parameter uncertainty
given the observed data. A dichotomous hypothesis test could be performed
with either a CI or a p value. The 100 (1 - \eqn{\alpha})\% confidence
interval contains all of the parameter values for which \emph{p} > \eqn{\alpha}
for the current data and model. For example, a 95\% confidence interval
contains all of the values for which p > .05.
\cr\cr
Note that a confidence interval including 0 \emph{does not} indicate that the null
(no effect) is true. Rather, it suggests that the observed data together with
the model and its assumptions combined do not provided clear evidence against
a parameter value of 0 (same as with any other value in the interval), with
the level of this evidence defined by the chosen \eqn{\alpha} level (Rafi &
Greenland, 2020; Schweder & Hjort, 2016; Xie & Singh, 2013). To infer no
effect, additional judgments about what parameter values are "close enough"
to 0 to be negligible are needed ("equivalence testing"; Bauer & Kiesser,
1996).
}

\section{Plotting with \code{see}}{

The \code{see} package contains relevant plotting functions. See the \href{https://easystats.github.io/see/articles/effectsize.html}{plotting vignette in the \code{see} package}.
}

\examples{
x <- c(1.83, 0.50, 1.62, 2.48, 1.68, 1.88, 1.55, 3.06, 1.30)
y <- c(0.878, 0.647, 0.598, 2.05, 1.06, 1.29, 1.06, 3.14, 1.29)
means_ratio(x, y)
means_ratio(x, y, adjust = FALSE)

means_ratio(x, y, log = TRUE)


# The ratio is scale invariant, making it a standardized effect size
means_ratio(3 * x, 3 * y)

}
\references{
Lajeunesse, M. J. (2011). On the meta-analysis of response ratios for studies
with correlated and multi-group designs. Ecology, 92(11), 2049-2055.
\doi{10.1890/11-0423.1}

Lajeunesse, M. J. (2015). Bias and correction for the log response ratio in
ecological meta-analysis. Ecology, 96(8), 2056-2063. \doi{10.1890/14-2402.1}

Hedges, L. V., Gurevitch, J., & Curtis, P. S. (1999). The meta-analysis of
response ratios in experimental ecology. Ecology, 80(4), 1150–1156.
\doi{10.1890/0012-9658(1999)080[1150:TMAORR]2.0.CO;2}
}
\seealso{
Other standardized differences: 
\code{\link{cohens_d}()},
\code{\link{mahalanobis_d}()},
\code{\link{p_superiority}()},
\code{\link{rank_biserial}()},
\code{\link{repeated_measures_d}()}
}
\concept{standardized differences}
