% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hop-index2.R, R/phop-index.R
\name{hop_index2}
\alias{hop_index2}
\alias{hop_index2_vec}
\alias{phop_index}
\alias{phop_index_vec}
\title{Hop along multiple inputs simultaneously relative to an index}
\usage{
hop_index2(.x, .y, .i, .starts, .stops, .f, ...)

hop_index2_vec(.x, .y, .i, .starts, .stops, .f, ..., .ptype = NULL)

phop_index(.l, .i, .starts, .stops, .f, ...)

phop_index_vec(.l, .i, .starts, .stops, .f, ..., .ptype = NULL)
}
\arguments{
\item{.x, .y}{\verb{[vector]}

Vectors to iterate over. Vectors of size 1 will be recycled.}

\item{.i}{\verb{[vector]}

The index vector that determines the window sizes. It is fairly common to
supply a date vector as the index, but not required.

There are 3 restrictions on the index:
\itemize{
\item The size of the index must match the size of \code{.x}, they will not be
recycled to their common size.
\item The index must be an \emph{increasing} vector, but duplicate values
are allowed.
\item The index cannot have missing values.
}}

\item{.starts, .stops}{\verb{[vector]}

Vectors of boundary values that make up the windows to bucket \code{.i} with.
Both \code{.starts} and \code{.stops} will be recycled to their common size, and
that common size will be the size of the result. Both vectors will be cast
to the type of \code{.i} using \code{\link[vctrs:vec_cast]{vctrs::vec_cast()}}. These boundaries are both
\emph{inclusive}, meaning that the slice of \code{.x} that will be used in each call
to \code{.f} is where \code{.i >= start & .i <= stop} returns \code{TRUE}.}

\item{.f}{\verb{[function / formula]}

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.}

\item{...}{Additional arguments passed on to the mapped function.}

\item{.ptype}{\verb{[vector(0) / NULL]}

A prototype corresponding to the type of the output.

If \code{NULL}, the default, the output type is determined by computing the
common type across the results of the calls to \code{.f}.

If supplied, the result of each call to \code{.f} will be cast to that type,
and the final output will have that type.

If \code{getOption("vctrs.no_guessing")} is \code{TRUE}, the \code{.ptype} must be
supplied. This is a way to make production code demand fixed types.}

\item{.l}{\verb{[list]}

A list of vectors. The length of \code{.l} determines the
number of arguments that \code{.f} will be called with. If \code{.l} has names,
they will be used as named arguments to \code{.f}. Elements of \code{.l} with size
1 will be recycled.}
}
\value{
A vector fulfilling the following invariants:

\subsection{\code{hop_index2()}}{
\itemize{
\item \code{vec_size(hop_index2(.x, .y, .starts, .stops)) == vec_size_common(.starts, .stops)}
\item \code{vec_ptype(hop_index2(.x, .y, .starts, .stops)) == list()}
}

}

\subsection{\code{hop_index2_vec()}}{
\itemize{
\item \code{vec_size(hop_index2_vec(.x, .y, .starts, .stops)) == vec_size_common(.starts, .stops)}
\item \code{vec_size(hop_index2_vec(.x, .y, .starts, .stops)[[1]]) == 1L}
\item \code{vec_ptype(hop_index2_vec(.x, .y, .starts, .stops, .ptype = ptype)) == ptype}
}

}

\subsection{\code{phop_index()}}{
\itemize{
\item \code{vec_size(phop_index(.l, .starts, .stops)) == vec_size_common(.starts, .stops)}
\item \code{vec_ptype(phop_index(.l, .starts, .stops)) == list()}
}

}

\subsection{\code{phop_index_vec()}}{
\itemize{
\item \code{vec_size(phop_index_vec(.l, .starts, .stops)) == vec_size_common(.starts, .stops)}
\item \code{vec_size(phop_index_vec(.l, .starts, .stops)[[1]]) == 1L}
\item \code{vec_ptype(phop_index_vec(.l, .starts, .stops, .ptype = ptype)) == ptype}
}

}
}
\description{
\code{hop_index2()} and \code{phop_index()} represent the combination
of \code{\link[=slide2]{slide2()}} and \code{\link[=pslide]{pslide()}} with \code{\link[=hop_index]{hop_index()}}, allowing you to iterate
over multiple vectors at once, relative to an \code{.i}-ndex with
boundaries defined by \code{.starts} and \code{.stops}.
}
\examples{
# Notice that `i` is an irregular index!
x <- 1:5
i <- as.Date("2019-08-15") + c(0:1, 4, 6, 7)

# Manually create starts/stops. They don't have to be equally spaced,
# and they don't have to be the same size as `.x` or `.i`.
starts <- as.Date(c("2019-08-15", "2019-08-18"))
stops <- as.Date(c("2019-08-16", "2019-08-23"))

# The output size is equal to the common size of `.starts` and `.stops`
hop_index2(x, i, i, starts, stops, ~data.frame(x = .x, y = .y))

}
\seealso{
\code{\link[=slide2]{slide2()}}, \code{\link[=slide_index2]{slide_index2()}}, \code{\link[=hop_index]{hop_index()}}
}
