# パラグラフ

連続した複数行は連結されて一つのパラグラフになります。

空行 (改行のみ、またはスペース、タブだけの行) はパラグラフの区切りになります。

* 記述例

```
例えば、
こういう風に記述すると、これらの行は
一つのパラグラフとして整形されます。
```

* 出力例

<p>例えば、
こういう風に記述すると、これらの行は
一つのパラグラフとして整形されます。</p>

# リンク

## [WikiName](WikiName)

大文字の英字で始まり、小文字の英字または数字が1文字以上続く

この条件が2回以上繰り返される単語はWikiNameになり自動的にリンクがはられます。

* 記述例

```
WikiName     - WikiName
HogeRule1    - WikiName
NOTWIKINAME  - 全て大文字なのでWikiNameではない
WikiNAME     - NAMEが全て大文字なのでWikiNameではない
fooWikiName  - 先頭に全て小文字の英字fooがあるためWikiNameではない
```

* 出力例

<ul>
<li><ul>
<li><a href="WikiName">WikiName</a>     - <a href="WikiName">WikiName</a></li>
<li><a href="HogeRule1">HogeRule1</a>    - <a href="WikiName">WikiName</a></li>
<li>NOTWIKINAME  - 全て大文字なのでWikiNameではない</li>
<li>WikiNAME     - NAMEが全て大文字なのでWikiNameではない</li>
<li>fooWikiName  - 先頭に全て小文字の英字fooがあるためWikiNameではない</li>
</ul></li>
</ul>

WikiNameの前に_^_をつけるとWikiNameへのリンクを抑制することができます。

* 記述例

```
WikiName     - WikiName
^WikiName    - WikiNameへのリンクを抑制
```

* 出力例

<ul>
<li><ul>
<li><a href="WikiName">WikiName</a>     - <a href="WikiName">WikiName</a></li>
<li>WikiName    - WikiNameへのリンクを抑制</li>
</ul></li>
</ul>

## ページへのリンク

ページ名を二つのカギカッコで囲むと、そのページへのリンクになります。

* 記述例

```
例えば[[逆引きRuby]]とすると、そのページへのリンクになります。
```

* 出力例

<p>例えば<a href="逆引きRuby">逆引きRuby</a>とすると、そのページへのリンクになります。</p>

## 任意のURLへのリンク

単語|URLを二つのカギカッコで囲むとを任意のURLへのリンクになります。

* 記述例

```
[[Yahoo!|http://www.yahoo.co.jp/]]とかもできます。
```

* 出力例

<p><a href="http://www.yahoo.co.jp/">Yahoo!</a>とかもできます。</p>

パラグラフ中にURLっぽいものがあると勝手にリンクがはられます。

* 記述例

```
Hikiのページはhttp://hikiwiki.org/ja/です。
```

* 出力例

<p>Hikiのページは<a href="http://hikiwiki.org/ja/">http://hikiwiki.org/ja/</a>です。</p>

このときURLの末尾がjpg,jpeg,png,gifだとIMGタグに展開されます。

* 記述例

```
http://jp.rubyist.net/theme/clover/clover_h1.png
```

* 出力例

<p><img src="http://jp.rubyist.net/theme/clover/clover_h1.png" alt="clover_h1.png"></p>

#整形済みテキスト

行の先頭がスペースまたはタブで始まっていると、その行は整形済みとして扱われます。

* 出力例

<pre>require 'cgi'

cgi = CGI::new
cgi.header

puts &lt;&lt;EOS
&lt;html&gt;
  &lt;head&gt;
    &lt;title&gt;Hello!&lt;/title&gt;
  &lt;/head&gt;
  &lt;body&gt;
  &lt;p&gt;Hello!&lt;/p&gt;
  &lt;/body&gt;
&lt;/html&gt;
EOS</pre>

# 文字の修飾

「'」2個ではさんだ部分は強調されます。

「'」3個ではさんだ部分はさらに強調されます。

「=」2個ではさんだ部分は取消線になります。

「`」2個ではさんだ部分は等幅表示になります。

* 記述例

```
このようにすると''強調''になります。
そして、このようにすると'''さらに強調'''されます。
==だるいけど==さらに、取り消し線もサポートしています。
またまた、このようにすると``等幅表示``になります。
```

* 出力例

<p>このようにすると<em>強調</em>になります。
そして、このようにすると<strong>さらに強調</strong>されます。
<del>だるいけど</del>さらに、取り消し線もサポートしています。
またまた、このようにすると<tt>等幅表示</tt>になります。</p>

# 見出し

「!」を行の先頭に書くと見出しになります。

「!」は一つから六つまで記述することが可能で、それぞれ\<H1\>〜\<H6\>に変換されます。

* 記述例

```
!見出し1
!!見出し2
!!!見出し3
!!!!見出し4
!!!!!見出し5
```

* 出力例

<h1>見出し1</h1>
<h2>見出し2</h2>
<h3>見出し3</h3>
<h4>見出し4</h4>
<h5>見出し5</h5>

# 水平線

マイナス記号「-」を行の先頭から4つ書くと水平線になります。

* 記述例

```
あいうえお。
----
かきくけこ。
```

* 出力例

<p>あいうえお。</p>
<hr>
<p>かきくけこ。</p>

# 箇条書き

「\*」を行の先頭に書くと箇条書きになります。

「\*」は一つから三つまで記述することが可能で入れ子にすることもできます。

「#」を行の先頭に書くと番号付きの箇条書きになります。

* 記述例

```
*アイテム1
**アイテム1.1
**アイテム1.2
***アイテム1.2.1
***アイテム1.2.2
***アイテム1.2.3
**アイテム1.3
**アイテム1.4
*アイテム2
```

```
#その1
#その2
##その2.1
##その2.2
##その2.3
#その3
##その3.1
###その3.1.1
###その3.1.2
```

* 出力例

<ul>
<li>アイテム1<ul>
<li>アイテム1.1</li>
<li>アイテム1.2<ul>
<li>アイテム1.2.1</li>
<li>アイテム1.2.2</li>
<li>アイテム1.2.3</li>
</ul></li>
<li>アイテム1.3</li>
<li>アイテム1.4</li>
</ul></li>
<li>アイテム2</li>
</ul>
<ol>
<li>その1</li>
<li>その2<ol>
<li>その2.1</li>
<li>その2.2</li>
<li>その2.3</li>
</ol></li>
<li>その3<ol>
<li>その3.1<ol>
<li>その3.1.1</li>
<li>その3.1.2</li>
</ol></li>
</ol></li>
</ol>

# 引用

「"」を行の先頭から二つ書くと引用になります。

* 記述例

```
""これは引用です。
""さらに引用します。
""続けて引用します。引用が連続する場合、
""このように一つの引用として
""展開されます。
```

* 出力例

<blockquote><p>これは引用です。
さらに引用します。
続けて引用します。引用が連続する場合、
このように一つの引用として
展開されます。</p>
</blockquote>

# 用語解説

コロン「:」を行の先頭に書き、続けて用語:解説文とすると用語解説になります。

* 記述例

```
:りんご:apple
:ゴリラ:gorilla
:ラクダ:camel
```

* 出力例

<dl>
<dt>りんご</dt>
<dd>apple
</dd>
<dt>ゴリラ</dt>
<dd>gorilla
</dd>
<dt>ラクダ</dt>
<dd>camel
</dd>
</dl>

# 表

表(テーブル)は「||」で始めます。
セルの項目の頭に「!」をつけることにより見出しセルになります。
行の連結には「^」を列の連結には「\>」を、連結したい数だけセルの項目頭につけてください。

* 記述例

```
||!行見出し＼列見出し||!列-A||!列-B||!列-C||!>列-D-E（横連結）
||!行-1||A1||B1||^C1-C2（縦連結）||D1||E1
||!行-2||A2||B2||^>D2-E2-D3-E3（縦横連結）
||!行-3||>>A3-C3（横３連結）
```

* 出力例

<table border="1">
<tr><th>行見出し＼列見出し</th><th>列-A</th><th>列-B</th><th>列-C</th><th colspan="2">列-D-E（横連結）
</th></tr>
<tr><th>行-1</th><td>A1</td><td>B1</td><td rowspan="2">C1-C2（縦連結）</td><td>D1</td><td>E1
</td></tr>
<tr><th>行-2</th><td>A2</td><td>B2</td><td rowspan="2" colspan="2">D2-E2-D3-E3（縦横連結）
</td></tr>
<tr><th>行-3</th><td colspan="3">A3-C3（横３連結）
</td></tr>
</table>

#コメント行

「//」が行頭にある行はコメント行になり、出力されなくなります。

* 記述例

```
// ここはコメントです。
```

* 出力例（表示されません）

#プラグイン

「{」二つと「}」二つで囲むとプラグインを呼び出すことができます。
パラメータを複数行に分けて書くことも可能です。
プラグインのみを単独行に書いた場合はブロックプラグインになり、前後に\<p\>と\</p\>が付かなくなります。

* 記述例

```
{{recent(3)}}
```

* 複数行記述例

```
{{pre(
 パラメータ１
 パラメータ２
 パラメータ３
)}}
```

